import { jsx } from "react/jsx-runtime";
import classnames from "classnames";
import * as React from "react";
const TldrawUiButton = React.forwardRef(
  function TldrawUiButton2({ children, disabled, type, ...props }, ref) {
    return /* @__PURE__ */ jsx(
      "button",
      {
        ref,
        type: "button",
        draggable: false,
        disabled,
        ...props,
        className: classnames("tlui-button", `tlui-button__${type}`, props.className),
        children
      }
    );
  }
);
export {
  TldrawUiButton
};
//# sourceMappingURL=TldrawUiButton.mjs.map
